/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.CiscoDeviceEvent;
import apiipc.generated.events.CiscoDeviceEventListener;
import apiipc.generated.sim.CiscoDevice;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiscoDeviceEventRegistry
extends IPCEventRegistry {
    protected Set<CiscoDeviceEventListener> globalListeners = new HashSet<CiscoDeviceEventListener>();
    protected Map<String, Set<CiscoDeviceEventListener>> specificObjectListeners = new HashMap<String, Set<CiscoDeviceEventListener>>();

    public CiscoDeviceEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "CiscoDevice";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        CiscoDeviceEvent ciscoDeviceEvent = null;
        if (string.equalsIgnoreCase("doneBooting")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.DoneBooting(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineConnected")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.LineConnected(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineDisconnected")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.LineDisconnected(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineAuthenticationStarted")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.LineAuthenticationStarted(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineAuthenticationFailed")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.LineAuthenticationFailed(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineAuthenticationFinished")) {
            ciscoDeviceEvent = new CiscoDeviceEvent.LineAuthenticationFinished(iPCEventLTV);
        } else {
            return;
        }
        for (CiscoDeviceEventListener object : this.globalListeners) {
            object.handleEvent(ciscoDeviceEvent);
        }
        Set<CiscoDeviceEventListener> set = this.specificObjectListeners.get(ciscoDeviceEvent.objectUUID.toString());
        if (set != null) {
            for (CiscoDeviceEventListener ciscoDeviceEventListener : set) {
                ciscoDeviceEventListener.handleEvent(ciscoDeviceEvent);
            }
        }
    }

    public void addListenerFiltered(CiscoDeviceEventListener ciscoDeviceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("doneBooting");
                this.register("lineConnected");
                this.register("lineDisconnected");
                this.register("lineAuthenticationStarted");
                this.register("lineAuthenticationFailed");
                this.register("lineAuthenticationFinished");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(ciscoDeviceEventListener);
    }

    public void addSpecificListenerFiltered(CiscoDeviceEventListener ciscoDeviceEventListener, CiscoDevice ciscoDevice, List<String> list) throws IOException {
        UUID uUID = ciscoDevice.getObjectUUID();
        String string = uUID.toString();
        Set<CiscoDeviceEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<CiscoDeviceEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "doneBooting");
                this.register(uUID, "lineConnected");
                this.register(uUID, "lineDisconnected");
                this.register(uUID, "lineAuthenticationStarted");
                this.register(uUID, "lineAuthenticationFailed");
                this.register(uUID, "lineAuthenticationFinished");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(ciscoDeviceEventListener);
    }

    public void removeListenerFiltered(CiscoDeviceEventListener ciscoDeviceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("doneBooting");
                this.deregister("lineConnected");
                this.deregister("lineDisconnected");
                this.deregister("lineAuthenticationStarted");
                this.deregister("lineAuthenticationFailed");
                this.deregister("lineAuthenticationFinished");
            }
            this.globalListeners.remove(ciscoDeviceEventListener);
        }
    }

    public void removeSpecificListenerFiltered(CiscoDeviceEventListener ciscoDeviceEventListener, CiscoDevice ciscoDevice, List<String> list) throws IOException {
        UUID uUID = ciscoDevice.getObjectUUID();
        String string = uUID.toString();
        Set<CiscoDeviceEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "doneBooting");
            this.deregister(uUID, "lineConnected");
            this.deregister(uUID, "lineDisconnected");
            this.deregister(uUID, "lineAuthenticationStarted");
            this.deregister(uUID, "lineAuthenticationFailed");
            this.deregister(uUID, "lineAuthenticationFinished");
            set.remove(ciscoDeviceEventListener);
        }
    }

    public void addListener(CiscoDeviceEventListener ciscoDeviceEventListener) throws IOException {
        this.addListenerFiltered(ciscoDeviceEventListener, null);
    }

    public void addListener(CiscoDeviceEventListener ciscoDeviceEventListener, CiscoDevice ciscoDevice) throws IOException {
        this.addSpecificListenerFiltered(ciscoDeviceEventListener, ciscoDevice, null);
    }

    public void removeListener(CiscoDeviceEventListener ciscoDeviceEventListener) throws IOException {
        this.removeListenerFiltered(ciscoDeviceEventListener, null);
    }

    public void removeListener(CiscoDeviceEventListener ciscoDeviceEventListener, CiscoDevice ciscoDevice) throws IOException {
        this.removeSpecificListenerFiltered(ciscoDeviceEventListener, ciscoDevice, null);
    }
}

